/*
 * Decompiled with CFR 0.152.
 */
package org.chm4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.chm4j.ChmEntry;

public final class ChmFile {
    private File file;

    public ChmFile(String pathname) throws FileNotFoundException {
        this(new File(pathname));
    }

    public ChmFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("file not found : " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("the file is a directory : " + file.getAbsolutePath());
        }
        this.file = file;
    }

    public ChmEntry[] entries(ChmEntry.Attribute ... attributes) throws IOException {
        return this.entries((ChmEntry)null, attributes);
    }

    public ChmEntry[] entries(ChmEntry parent, ChmEntry.Attribute ... attributes) throws IllegalArgumentException, IOException {
        if (parent != null && !this.equals(parent.getChmFile())) {
            throw new IllegalArgumentException("the entry does not belong to this file");
        }
        int flags = 0;
        for (ChmEntry.Attribute type : attributes) {
            flags += type.getValue();
        }
        if (flags == 0) {
            flags = ChmEntry.Attribute.ALL.getValue();
        }
        return this.entries(this.file.getCanonicalPath(), parent == null ? "/" : parent.getPath(), flags);
    }

    private native ChmEntry[] entries(String var1, String var2, int var3) throws IOException;

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChmFile) {
            return this.file.equals(((ChmFile)obj).getFile());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }

    static {
        System.loadLibrary("chm4j-native");
    }
}

