/*
 * Decompiled with CFR 0.152.
 */
package org.chm4j.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.chm4j.ChmEntry;
import org.chm4j.ChmFile;

public class TestChm {
    public static void main(String ... args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("use : chm4j file [output-dir]");
            System.exit(0);
        }
        try {
            ChmEntry[] entries;
            ChmFile cFile = new ChmFile(args[0]);
            String dir = args.length == 2 ? args[1] : ".";
            ChmEntry.Attribute attributes = ChmEntry.Attribute.ALL;
            for (ChmEntry entry : entries = cFile.entries(attributes)) {
                TestChm.listChmEntry(dir, entry, attributes);
            }
        }
        catch (IOException ex) {
            System.out.println("Error : " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listChmEntry(String output, ChmEntry entry, ChmEntry.Attribute attributes) throws IOException {
        TestChm.printEntry(entry);
        File dest = new File(output, entry.getPath());
        if (entry.hasAttribute(ChmEntry.Attribute.DIRECTORY)) {
            if (!dest.isDirectory() && !dest.mkdirs()) {
                throw new IOException("failed to create directory : " + dest);
            }
            for (ChmEntry e : entry.entries(attributes)) {
                TestChm.listChmEntry(output, e, attributes);
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            try {
                int nbRead;
                in = entry.getInputStream();
                out = new FileOutputStream(dest);
                int bufferSize = 1024;
                byte[] data = new byte[bufferSize];
                while ((nbRead = in.read(data)) > 0) {
                    out.write(data, 0, nbRead);
                    out.flush();
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }

    private static void printEntry(ChmEntry entry) {
        StringBuilder sb = new StringBuilder("Extract entry " + entry + "(");
        boolean first = true;
        for (ChmEntry.Attribute attribute : entry.getAttributes()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append((Object)attribute);
        }
        sb.append(")");
        System.out.println(sb.toString());
    }
}

