/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.DescriptorIndexNode;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTObject;
import com.pff.PSTTableBCItem;
import java.io.IOException;
import java.util.UUID;

public class PSTMessageStore
extends PSTObject {
    PSTMessageStore(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        super(theFile, descriptorIndexNode);
    }

    public UUID getTagRecordKeyAsUUID() {
        int guidEntryType = 4089;
        if (this.items.containsKey(guidEntryType)) {
            PSTTableBCItem item = (PSTTableBCItem)this.items.get(guidEntryType);
            int offset = 0;
            byte[] bytes = item.data;
            long mostSigBits = PSTObject.convertLittleEndianBytesToLong(bytes, offset, offset + 4) << 32 | PSTObject.convertLittleEndianBytesToLong(bytes, offset + 4, offset + 6) << 16 | PSTObject.convertLittleEndianBytesToLong(bytes, offset + 6, offset + 8);
            long leastSigBits = PSTObject.convertBigEndianBytesToLong(bytes, offset + 8, offset + 16);
            return new UUID(mostSigBits, leastSigBits);
        }
        return null;
    }

    public String getDisplayName() {
        int displayNameEntryType = 12289;
        if (this.items.containsKey(displayNameEntryType)) {
            return this.getStringItem(displayNameEntryType);
        }
        return "";
    }

    public String getDetails() {
        return this.items.toString();
    }
}

