/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BaseBlock;

public class AVHeader
extends BaseBlock {
    public static final int avHeaderSize = 7;
    private byte unpackVersion;
    private byte method;
    private byte avVersion;
    private int avInfoCRC;

    public AVHeader(BaseBlock bb, byte[] avHeader) {
        super(bb);
        int pos = 0;
        this.unpackVersion = (byte)(this.unpackVersion | avHeader[pos] & 0xFF);
        this.method = (byte)(this.method | avHeader[++pos] & 0xFF);
        this.avVersion = (byte)(this.avVersion | avHeader[++pos] & 0xFF);
        this.avInfoCRC = Raw.readIntLittleEndian(avHeader, ++pos);
    }

    public int getAvInfoCRC() {
        return this.avInfoCRC;
    }

    public byte getAvVersion() {
        return this.avVersion;
    }

    public byte getMethod() {
        return this.method;
    }

    public byte getUnpackVersion() {
        return this.unpackVersion;
    }
}

